//=============================================================================
// WorkBenchMenuMain
//=============================================================================

class WorkBenchMenuEquipRifle expands MenuUIWindow;

//Universals
var DeusExPlayer Player;
var PartsBag Bench;
var MSMassEffectMutator Mutator;

//Window Specifics
var MenuUIActionButtonWindow exitButton;
var localized string exitButtonText;

var class<CraftingStock> CurStock;
var class<CraftingBody> CurBody;
var class<CraftingFeed> CurFeed;
var class<CraftingPin> CurPin;
var class<CraftingBarrel> CurBarrel;
var class<CraftingAccesory> CurAccesoryType;
var CustomRifle CurWeapon;
var CraftingAccesory CurAccesory;

var Window Overlay1, Overlay2, PinOverlay, EquipOverlay;
var Window StockDisplay, BodyDisplay, FeedDisplay, PinDisplay, BarrelDisplay;

var ModifiedPersonaTextWindow Durabilities[5];

var ModifiedPersonaTextWindow  StatDisplay, AccText;
var MenuUIEditWindow CustomNameField;

var Window ColorDisplay;
var ColorButtonForward NextWeapon;
var ColorButtonBackward PrevWeapon;
var int CurColor; //White, Yellow, Green, Blue, Purple, Red, Orange.
var String ColorPickerValues[7]; //these might be slightly off, but it works.

var Window Last;

var Window AccDisplay;
var ColorButtonForward NextAcc;
var ColorButtonBackward PrevAcc;

var PersonaActionButtonWindow UnequipButton;

// ----------------------------------------------------------------------
// InitWindow()
//
// Initialize the Window... it's way down there...
// In the meantime, here's a lot of precautionary vomit!
// ----------------------------------------------------------------------


function bool CanPushScreen(Class <DeusExBaseWindow> newScreen)
{
 return false;
}

function bool CanStack()
{
 return false;
}

event bool VirtualKeyPressed(EInputKey key, bool bRepeat)
{
 return false;
}

event bool RawKeyPressed(EInputKey key, EInputState iState, bool bRepeat)
{
 return false;
}

event InitWindow()
{
 local int i, j;

	Super.InitWindow();
        SetTitle("Custom Rifle Equipping");
        exitButton = winButtonBar.AddButton(exitButtonText, HALIGN_Left);
	
	CreateOverlays();
	CreateButtons();
        CreateDurabilities();
	CreateTextDisplay();

	CustomNameField = CreateMenuEditWindow(347, 272, 132, 24, winClient);
	CustomNameField.SetText("");
	CustomNameField.SetSensitivity(False);
}

function CreateTextDisplay()
{
 StatDisplay = ModifiedPersonaTextWindow(NewChild(Class'ModifiedPersonaTextWindow'));
 StatDisplay.SetPos(16, 268);
 StatDisplay.SetSize(240, 96);
 StatDisplay.SetFont(Font'FontMenuHeaders');

 AccText = ModifiedPersonaTextWindow(NewChild(Class'ModifiedPersonaTextWindow'));
 AccText.SetPos(40, 44);
 AccText.SetSize(64, 64);
 AccText.SetFont(Font'FontMenuHeaders');
}

function CreateDurabilities()
{
 Durabilities[0] = ModifiedPersonaTextWindow(NewChild(Class'ModifiedPersonaTextWindow'));
 Durabilities[0].SetPos(67, 107);
 Durabilities[0].SetSize(96, 20);
 Durabilities[0].SetFont(Font'FontMenuHeaders');
 Durabilities[1] = ModifiedPersonaTextWindow(NewChild(Class'ModifiedPersonaTextWindow'));
 Durabilities[1].SetPos(203, 103);
 Durabilities[1].SetSize(96, 20);
 Durabilities[1].SetFont(Font'FontMenuHeaders');
 Durabilities[2] = ModifiedPersonaTextWindow(NewChild(Class'ModifiedPersonaTextWindow'));
 Durabilities[2].SetPos(227, 139);
 Durabilities[2].SetSize(96, 20);
 Durabilities[2].SetFont(Font'FontMenuHeaders');
 Durabilities[3] = ModifiedPersonaTextWindow(NewChild(Class'ModifiedPersonaTextWindow'));
 Durabilities[3].SetPos(172, 91);
 Durabilities[3].SetSize(96, 20);
 Durabilities[3].SetFont(Font'FontMenuHeaders');
 Durabilities[4] = ModifiedPersonaTextWindow(NewChild(Class'ModifiedPersonaTextWindow'));
 Durabilities[4].SetPos(375, 84);
 Durabilities[4].SetSize(96, 20);
 Durabilities[4].SetFont(Font'FontMenuHeaders');
}

function CreateButtons()
{
 	NextWeapon = ColorButtonForward(NewChild(Class'ColorButtonForward'));
	NextWeapon.SetPos(490, 288);
 	PrevWeapon = ColorButtonBackward(NewChild(Class'ColorButtonBackward'));
	PrevWeapon.SetPos(324, 288);
}

function CreateOverlays()
{
	Overlay1 = NewChild(Class'Window');
	SetupOverlay(Overlay1, 0, 0, 256, 256);
	Overlay1.SetBackground(Texture'WorkbenchRifleOverlay1');
	
	Overlay2 = NewChild(Class'Window');
	SetupOverlay(Overlay2, 256, 0, 256, 256);	
	Overlay2.SetBackground(Texture'WorkbenchRifleOverlay2');
	
	StockDisplay = NewChild(Class'Window');
	SetupOverlay(StockDisplay, 0, 0, 256, 256);
		
	FeedDisplay = NewChild(Class'Window');
	SetupOverlay(FeedDisplay, 201, 107, 128, 128);
	
	BarrelDisplay = NewChild(Class'Window');
	SetupOverlay(BarrelDisplay, 256, 0, 256, 256);
	
	BodyDisplay = NewChild(Class'Window');
	SetupOverlay(BodyDisplay, 117, 75, 256, 128);
	
	//Reinforce the pin overlay, otherwise it's invisible
	
	PinOverlay = NewChild(Class'Window');
	SetupOverlay(PinOverlay, 0, 0, 256, 140);
	PinOverlay.SetBackground(Texture'WorkBenchRiflePinOverlay');
	
	PinDisplay = NewChild(Class'Window');
	SetupOverlay(PinDisplay, 0, 0, 256, 128);
	
	ColorDisplay = NewChild(Class'Window');
	SetupOverlay(ColorDisplay, 375, 352, 32, 32);
	ColorDisplay.SetBackground(Texture'WBMWhite');
	
	EquipOverlay = NewChild(Class'Window');
	SetupOverlay(EquipOverlay, 40, 24, 64, 64);	
	EquipOverlay.SetBackground(Texture'WorkbenchAttachmentBG');

	AccDisplay = NewChild(Class'Window');
	SetupOverlay(AccDisplay, 40, 24, 64, 64);
	
 	NextAcc = ColorButtonForward(NewChild(Class'ColorButtonForward'));
	NextAcc.SetPos(104, 40);
 	PrevAcc = ColorButtonBackward(NewChild(Class'ColorButtonBackward'));
	PrevAcc.SetPos(8, 40);
	
	NextAcc.Show(False);
  	PrevAcc.Show(False);
  	//NextAcc.SetSensitivity(False);
  	PrevAcc.SetSensitivity(False);

	UnequipButton = PersonaActionButtonWindow(NewChild(Class'PersonaActionButtonWindow'));
	UnequipButton.SetPos(40, 24);
	UnequipButton.SetButtonText("Unequip");
	UnequipButton.SetSensitivity(False);
	UnequipButton.Show(False);
}

function SetupOverlay(Window Win, int PosX, int PosY, int WidthX, int HeightY)
{
	win.SetBackgroundStyle(DSTY_Masked);
	win.SetPos(PosX, PosY);
	win.SetSize(WidthX, HeightY);
}

function UpdateIcons()
{
 if (CurWeapon != None)
 {
  if (CurWeapon.CurStockDurability > 0) StockDisplay.SetBackground(CurStock.Default.BenchIcon);
  if (CurWeapon.CurBodyDurability > 0) BodyDisplay.SetBackground(CurBody.Default.BenchIcon);
  if (CurWeapon.CurFeedDurability > 0) FeedDisplay.SetBackground(CurFeed.Default.BenchIcon);
  if (CurWeapon.CurPinDurability > 0) PinDisplay.SetBackground(CurPin.Default.BenchIcon);
  if (CurWeapon.CurBarrelDurability > 0) BarrelDisplay.SetBackground(CurBarrel.Default.BenchIcon);

  NextAcc.Show(True);
  PrevAcc.Show(True);
  //NextAcc.SetSensitivity(True);
  PrevAcc.SetSensitivity(True);
 }
 
 if (CurWeapon == None)
 {
  NextAcc.Show(False);
  PrevAcc.Show(False);
  //NextAcc.SetSensitivity(False);
  PrevAcc.SetSensitivity(False);
 }
 
 UpdateStats();
 UpdateColor();
}

function UpdateColor()
{
 if (CurWeapon == None) return;
 
 CurColor = GetCurrentColor();
 
 if (CurColor == 0) ColorDisplay.SetBackground(Texture'WBMWhite');
 if (CurColor == 1) ColorDisplay.SetBackground(Texture'WBMGold');
 if (CurColor == 2) ColorDisplay.SetBackground(Texture'WBMGreen');
 if (CurColor == 3) ColorDisplay.SetBackground(Texture'WBMBlue');
 if (CurColor == 4) ColorDisplay.SetBackground(Texture'WBMPurple');
 if (CurColor == 5) ColorDisplay.SetBackground(Texture'WBMRed');
 if (CurColor == 6) ColorDisplay.SetBackground(Texture'WBMOrange');
}

function int GetCurrentColor()
{
 local int i;
 
 for(i=0; i<7; i++)
 {
  if (CurWeapon.CustomColor ~= ColorPickerValues[i])
  {
   return i;
  }
 }
 
 return 0;
}

function UpdateStats()
{
 
 StatDisplay.SetText(BuildWeaponStats());
 
 if (CurWeapon.CurStockDurability > 0) Durabilities[0].SetText(CurWeapon.CurStockDurability$"/"$CurWeapon.StockDurability);
 if (CurWeapon.CurBodyDurability > 0) Durabilities[1].SetText(CurWeapon.CurBodyDurability$"/"$CurWeapon.BodyDurability);
 if (CurWeapon.CurFeedDurability > 0) Durabilities[2].SetText(CurWeapon.CurFeedDurability$"/"$CurWeapon.FeedDurability);
 if (CurWeapon.CurPinDurability > 0) Durabilities[3].SetText(CurWeapon.CurPinDurability$"/"$CurWeapon.PinDurability);
 if (CurWeapon.CurBarrelDurability > 0) Durabilities[4].SetText(CurWeapon.CurBarrelDurability$"/"$CurWeapon.BarrelDurability);
 //if (CurWeapon.CurAccesoryDurability > 0) AccText.SetText(CurWeapon.CurAccesoryDurability$"/"$CurWeapon.AccesoryDurability);

 if (CurWeapon.CurStockDurability <= 0 || CurStock == None) Durabilities[0].SetText("");
 if (CurWeapon.CurBodyDurability <= 0 || CurBody == None) Durabilities[1].SetText("");
 if (CurWeapon.CurFeedDurability <= 0 || CurFeed == None) Durabilities[2].SetText("");
 if (CurWeapon.CurPinDurability <= 0 || CurPin == None) Durabilities[3].SetText("");
 if (CurWeapon.CurBarrelDurability <= 0 || CurBarrel == None) Durabilities[4].SetText("");
 //if (CurWeapon.CurAccesoryDurability <= 0 || CurAccesory == None) AccText.SetText("");
 
 CustomNameField.SetText(CurWeapon.CustomName);
}

function UpdateParts()
{
 CurStock = class<CraftingStock>(DynamicLoadObject(CurWeapon.StockName, class'Class'));
 CurBody = class<CraftingBody>(DynamicLoadObject(CurWeapon.BodyName, class'Class'));
 CurFeed = class<CraftingFeed>(DynamicLoadObject(CurWeapon.FeedName, class'Class'));
 CurPin = class<CraftingPin>(DynamicLoadObject(CurWeapon.PinName, class'Class'));
 CurBarrel = class<CraftingBarrel>(DynamicLoadObject(CurWeapon.BarrelName, class'Class'));
}

function UpdateAccesory()
{
 local CraftingAccesory TempAccesory;
 local string S;
 
 if (CurWeapon.CurAccesoryDurability > 0)
 {
  CurAccesoryType = class<CraftingAccesory>(DynamicLoadObject(CurWeapon.AccesoryName, class'Class'));
  TempAccesory = Bench.Spawn(CurAccesoryType,,,Bench.Location + vect(0,0,30));
  
  AccDisplay.SetBackground(TempAccesory.BenchIcon);
  AccText.SetText("|p3"$TempAccesory.AccesoryType$CR()$"|p4"$CurWeapon.CurAccesoryDurability$"/"$CurWeapon.AccesoryDurability);
  TempAccesory.Destroy();
  
  UnequipButton.Show(True);
  UnequipButton.SetSensitivity(True);
 }

 if (CurWeapon.CurAccesoryDurability <= 0)
 {
  CurAccesoryType = None;
  UnequipButton.Show(False);
  UnequipButton.SetSensitivity(False);
  AccText.SetText("");
  AccDisplay.SetBackground(None);
 }
}

function ClearAccesory()
{
 RemoveAccesory();
 
 CurAccesoryType = None;
 UnequipButton.Show(False);
 UnequipButton.SetSensitivity(False);
 AccText.SetText("");
 CurWeapon.CurAccesoryDurability = 0;
 CurWeapon.AccesoryDurability = 0;
 CurWeapon.AccesoryName = "";
 CurWeapon.Accesory = "";
 CurWeapon.ResetAccesory();
 AccDisplay.SetBackground(None);
 
 UpdateAccesory();
}

function ReplaceAccesory()
{
 CurWeapon.AccesoryName = String(CurAccesory.Class);
 CurWeapon.CurAccesoryDurability = CurAccesory.CurDurability;
 CurWeapon.AccesoryDurability = CurAccesory.Durability;
 CurWeapon.Accesory = CurAccesory.AccesoryType;
 CurWeapon.ResetAccesory();
 
 AccDisplay.SetBackground(CurAccesory.BenchIcon);
 
 CurAccesory.Destroy();
}

function RemoveAccesory()
{
 local Class<CraftingAccesory> CA;
 local CraftingAccesory Acc;
 
 CA = class<CraftingAccesory>(DynamicLoadObject(CurWeapon.AccesoryName, class'Class'));
 Acc = Bench.Spawn(CA,,,Bench.Location + vect(0,0,30));
 Acc.CurDurability = CurWeapon.CurAccesoryDurability;
 Acc.Frob(Player, None);
}

simulated function String FormatFloatString(float value, float precision)
{
	local string str;

	if (precision == 0.0)
		return "ERR";

	// build integer part
	str = String(Int(value));

	// build decimal part
	if (precision < 1.0)
	{
		value -= Int(value);
		str = str $ "." $ String(Int((0.5 * precision) + value * (1.0 / precision)));
	}

	return str;
}

function ClearIcons()
{
 if (CurStock == None) StockDisplay.SetBackground(None);
 if (CurBody == None) BodyDisplay.SetBackground(None);
 if (CurFeed == None) FeedDisplay.SetBackground(None);
 if (CurPin == None) PinDisplay.SetBackground(None);
 if (CurBarrel == None) BarrelDisplay.SetBackground(None);
 if (CurAccesory == None) AccDisplay.SetBackground(None);
}

//=============================
//NO STOPPING THIS ONE.
//=============================
function AbsClearIcons()
{
 StockDisplay.SetBackground(None);
 BodyDisplay.SetBackground(None);
 FeedDisplay.SetBackground(None);
 PinDisplay.SetBackground(None);
 BarrelDisplay.SetBackground(None);
 AccDisplay.SetBackground(None);
}

function String BuildWeaponStats()
{
 local string S, Modes, Caliber, RateS, ReloadS;
 local int Recoil, Weight, Accuracy, Capacity;
 local float Reload, Rate;
 
 if (CurWeapon == None || CurWeapon.bDeleteMe) return "";
 
 Weight = 25;
 Accuracy = 75;
 Reload = 3;
 Rate = 0.1;
 Recoil = 5;
 
 if (CurBarrel != None) 
 {
  Caliber = "Caliber: "$FormatFloatString(  float(CurBarrel.Default.CaliberType) / 100, 0.01  )$"mm";
  Accuracy += CurBarrel.Default.AccuracyMod * 5;
  Recoil += CurBarrel.Default.RecoilMod;
 }
 if (CurBody != None)
 {
  Weight += CurBody.Default.WeightMod;
 }
 if (CurFeed != None)
 {
  Weight += CurFeed.Default.WeightMod;
  Capacity = CurFeed.Default.CapacityMod;
  Reload += CurFeed.Default.ReloadMod;
 }
 if (CurPin != None)
 {
  Reload += CurPin.Default.ReloadMod;
  Rate += CurPin.Default.RateMod;
  
  Modes = "Modes: Semi ";
  if (CurPin.Default.bHasBurst) Modes = Modes@"Burst";
  if (CurPin.Default.bHasAuto) Modes = Modes@"Auto ";
 }
 if (CurStock != None)
 {
  Recoil += CurStock.Default.RecoilMod;
  Weight += CurStock.Default.WeightMod;
 }
 if (CurWeapon.CurStockDurability <= 0)
 {
  Recoil = 10;
 }
 
 ReloadS = FormatFloatString(Reload, 0.1);
 RateS = FormatFloatString(Rate, 0.01);
 
 S = Modes@Caliber$CR()$"Refire: "$RateS@"Reload: "$ReloadS$CR()$"Recoil: "$Recoil@"Weight: "$Weight$CR()$"Accuracy: "$Accuracy$"%"@"Capacity: "$Capacity@"Rounds";
 
 return S;
}

function bool ButtonActivated( Window buttonPressed )
{
	local bool bHandled;
	local name TempName;

	bHandled = True;

	Super.ButtonActivated(buttonPressed);

	switch(buttonPressed)
	{
		case exitButton:
			//Ralph.ChargeTheGates(TempName);
			// Do stuff

			Last.Show(True);

			root.PopWindow();
			bHandled = True;
			break;

		case NextWeapon:
			ForwardWeapon();
			bHandled = True;
			break;
		case PrevWeapon:
			BackwardWeapon();
			bHandled = True;
			break;

		case NextAcc:
			ForwardAccesory();
			bHandled = True;
			break;
		case PrevAcc:
			BackwardAccesory();
			bHandled = True;
			break;
		case UnequipButton:
			ClearAccesory();
			bHandled = True;
			break;

		default:
			bHandled = False;
			break;
	}

	/*if (ButtonPressed != exitButton)
	{
		UpdateInfo();
	}*/

	return bHandled;
}

//==================================================
//++++++++++++++++++++++++++++++++++++++++++++++++++
//NEXT PART FUNCTIONS BEGIN
//++++++++++++++++++++++++++++++++++++++++++++++++++
//==================================================

function ForwardWeapon()
{
 local CustomRifle P, Pick, First, Last;
 local bool bNext;
 
 forEach Player.AllActors(class'CustomRifle', P)
 {
  if (P.Owner == Player)
  {
   if (First == None) First = P;
   Last = P;
   
   if (bNext)
   {
    Pick = P;
    break;
   }
   if (CurWeapon == None)
   {
    Pick = First;
    break;
   }
   
   if (P == CurWeapon) bNext = True;
  }
 }
 
 if (Pick == None)
 {
  Pick = First;
 }
 
 AbsClearIcons();
 CurWeapon = Pick;
 UpdateParts();
 UpdateAccesory();
 UpdateIcons();
}


/*function ForwardAccesory()
{
 local CraftingAccesory P, Pick, First, Last;
 local bool bNext;
 
 forEach Player.AllActors(class'CraftingAccesory', P)
 {
  if (P.Owner == Player && !P.bDeleteMe && CurWeapon.CanHaveAccesory(P.AccesoryType))
  {
   if (First == None) First = P;
   Last = P;
   
   if (bNext)
   {
    Pick = P;
    break;
   }
   if (CurAccesoryType == None && First != None)
   {
    Pick = First;
    break;
   }
   
   if (P.Class == CurAccesoryType) bNext = True;
  }
 }
 
 if (Pick == None && First != None)
 {
  Pick = First;
 }
 
 if (Pick != None)
 {
  AbsClearIcons();
  RemoveAccesory();
  CurAccesory = Pick;
  ReplaceAccesory();
  UpdateParts();
  UpdateAccesory();
  UpdateIcons();
 }
}*/


function BackwardWeapon()
{
 local CustomRifle P, Pick, First, Last;
 
 forEach Player.AllActors(class'CustomRifle', P)
 {
  if (P.Owner == Player)
  {
   if (First == None) First = P;
   
   if (P == CurWeapon && P != First)
   {
    Pick = Last;
    break;
   }
   
   Last = P;
  }
 }
 
 if (CurWeapon == None || Pick == None)
 {
  Pick = Last;
 }

 AbsClearIcons();
 CurWeapon = Pick;
 UpdateParts();
 UpdateAccesory();
 UpdateIcons();
}


/*function BackwardAccesory()
{
 local CraftingAccesory P, Pick, First, Last;
 
 forEach Player.AllActors(class'CraftingAccesory', P)
 {
  if (P.Owner == Player && !P.bDeleteMe && CurWeapon.CanHaveAccesory(P.AccesoryType))
  {
   if (First == None) First = P;
   
   if (P.Class == CurAccesoryType && P != First)
   {
    Pick = Last;
    break;
   }
   
   Last = P;
  }
 }
 
 if ((CurAccesoryType == None || Pick == None) && Last != None)
 {
  Pick = Last;
 }

 if (Pick != None)
 {
  AbsClearIcons();
  RemoveAccesory();
  CurAccesory = Pick;
  ReplaceAccesory();
  UpdateParts();
  UpdateAccesory();
  UpdateIcons();
 }
}*/

//attempt 2
/*function BackwardAccesory()
{
 local CraftingAccesory P, Pick, First, Last;
 
 forEach Player.AllActors(class'CraftingAccesory', P)
 {
  if (P.Owner == Player && !P.bDeleteMe && CurWeapon.CanHaveAccesory(P.AccesoryType))
  {
   if (First == None) First = P;
   
   if (P.Class == CurAccesoryType && P != First)
   {
    Pick = Last;
    break;
   }
   
   Last = P;
  }
 }
 
 if (CurAccesoryType == None || Pick == None)
 {
  Pick = Last;
 }

 //CurPin = Pick;
 //UpdateIcons();
 if (Pick != None)
 {
  AbsClearIcons();
  RemoveAccesory();
  CurAccesory = Pick;
  ReplaceAccesory();
  UpdateParts();
  UpdateAccesory();
  UpdateIcons();
 }
}*/

//Dynamic attemps failed, so now this is manually
//Spoon fed in the lamest manner possible.
function ForwardAccesory()
{
 local class<CraftingAccesory> A, B, C, D, E, F;
 local CraftingAccesory Temp, Pick;
 
 CurWeapon.GetValidAccesoryClasses(A, B, C, D, E, F);
 
 //-------------------
 //SCENARIO NULL
 //-------------------
 if (CurWeapon.AccesoryName ~= "")
 {
  Temp = CraftingAccesory(Player.FindInventoryType(A));
  
  if (Temp != None && !Temp.bDeleteMe)
  {
   Pick = Temp;
  }
  if (Temp == None || Temp.bDeleteMe)
  {
   Temp = CraftingAccesory(Player.FindInventoryType(B));
  
   if (Temp != None && !Temp.bDeleteMe)
   {
    Pick = Temp;
   }
   if (Temp == None || Temp.bDeleteMe)
   {
    Temp = CraftingAccesory(Player.FindInventoryType(C));
   
    if (Temp != None && !Temp.bDeleteMe)
    {
     Pick = Temp;
    }
    if (Temp == None || Temp.bDeleteMe)
    {
     Temp = CraftingAccesory(Player.FindInventoryType(D));
    
     if (Temp != None && !Temp.bDeleteMe)
     {
      Pick = Temp;
     }
     if (Temp == None || Temp.bDeleteMe)
     {
      Temp = CraftingAccesory(Player.FindInventoryType(E));
     
      if (Temp != None && !Temp.bDeleteMe)
      {
       Pick = Temp;
      }
      if (Temp == None || Temp.bDeleteMe)
      {
       Temp = CraftingAccesory(Player.FindInventoryType(F));
      
       if (Temp != None && !Temp.bDeleteMe)
       {
        Pick = Temp;
       }
      }
     }
    }
   }
  }
 }
 
 //-------------------
 //SCENARIO A
 //-------------------
 if (CurWeapon.AccesoryName ~= String(A))
 {
  Temp = CraftingAccesory(Player.FindInventoryType(B));
  
  if (Temp != None && !Temp.bDeleteMe)
  {
   Pick = Temp;
  }
  if (Temp == None || Temp.bDeleteMe)
  {
   Temp = CraftingAccesory(Player.FindInventoryType(C));
  
   if (Temp != None && !Temp.bDeleteMe)
   {
    Pick = Temp;
   }
   if (Temp == None || Temp.bDeleteMe)
   {
    Temp = CraftingAccesory(Player.FindInventoryType(D));
   
    if (Temp != None && !Temp.bDeleteMe)
    {
     Pick = Temp;
    }
    if (Temp == None || Temp.bDeleteMe)
    {
     Temp = CraftingAccesory(Player.FindInventoryType(E));
    
     if (Temp != None && !Temp.bDeleteMe)
     {
      Pick = Temp;
     }
     if (Temp == None || Temp.bDeleteMe)
     {
      Temp = CraftingAccesory(Player.FindInventoryType(F));
     
      if (Temp != None && !Temp.bDeleteMe)
      {
       Pick = Temp;
      }
     }
    }
   }
  }
 }

 //-------------------
 //SCENARIO B
 //-------------------
 if (CurWeapon.AccesoryName ~= String(B))
 {
  Temp = CraftingAccesory(Player.FindInventoryType(C));
  
  if (Temp != None && !Temp.bDeleteMe)
  {
   Pick = Temp;
  }
  if (Temp == None || Temp.bDeleteMe)
  {
   Temp = CraftingAccesory(Player.FindInventoryType(D));
  
   if (Temp != None && !Temp.bDeleteMe)
   {
    Pick = Temp;
   }
   if (Temp == None || Temp.bDeleteMe)
   {
    Temp = CraftingAccesory(Player.FindInventoryType(E));
   
    if (Temp != None && !Temp.bDeleteMe)
    {
     Pick = Temp;
    }
    if (Temp == None || Temp.bDeleteMe)
    {
     Temp = CraftingAccesory(Player.FindInventoryType(F));
    
     if (Temp != None && !Temp.bDeleteMe)
     {
      Pick = Temp;
     }
     if (Temp == None || Temp.bDeleteMe)
     {
      Temp = CraftingAccesory(Player.FindInventoryType(A));
     
      if (Temp != None && !Temp.bDeleteMe)
      {
       Pick = Temp;
      }
     }
    }
   }
  }
 }

 //-------------------
 //SCENARIO C
 //-------------------
 if (CurWeapon.AccesoryName ~= String(C))
 {
  Temp = CraftingAccesory(Player.FindInventoryType(D));
  
  if (Temp != None && !Temp.bDeleteMe)
  {
   Pick = Temp;
  }
  if (Temp == None || Temp.bDeleteMe)
  {
   Temp = CraftingAccesory(Player.FindInventoryType(E));
  
   if (Temp != None && !Temp.bDeleteMe)
   {
    Pick = Temp;
   }
   if (Temp == None || Temp.bDeleteMe)
   {
    Temp = CraftingAccesory(Player.FindInventoryType(F));
   
    if (Temp != None && !Temp.bDeleteMe)
    {
     Pick = Temp;
    }
    if (Temp == None || Temp.bDeleteMe)
    {
     Temp = CraftingAccesory(Player.FindInventoryType(A));
    
     if (Temp != None && !Temp.bDeleteMe)
     {
      Pick = Temp;
     }
     if (Temp == None || Temp.bDeleteMe)
     {
      Temp = CraftingAccesory(Player.FindInventoryType(B));
     
      if (Temp != None && !Temp.bDeleteMe)
      {
       Pick = Temp;
      }
     }
    }
   }
  }
 }

 //-------------------
 //SCENARIO D
 //-------------------
 if (CurWeapon.AccesoryName ~= String(D))
 {
  Temp = CraftingAccesory(Player.FindInventoryType(E));
  
  if (Temp != None && !Temp.bDeleteMe)
  {
   Pick = Temp;
  }
  if (Temp == None || Temp.bDeleteMe)
  {
   Temp = CraftingAccesory(Player.FindInventoryType(F));
  
   if (Temp != None && !Temp.bDeleteMe)
   {
    Pick = Temp;
   }
   if (Temp == None || Temp.bDeleteMe)
   {
    Temp = CraftingAccesory(Player.FindInventoryType(A));
   
    if (Temp != None && !Temp.bDeleteMe)
    {
     Pick = Temp;
    }
    if (Temp == None || Temp.bDeleteMe)
    {
     Temp = CraftingAccesory(Player.FindInventoryType(B));
    
     if (Temp != None && !Temp.bDeleteMe)
     {
      Pick = Temp;
     }
     if (Temp == None || Temp.bDeleteMe)
     {
      Temp = CraftingAccesory(Player.FindInventoryType(C));
     
      if (Temp != None && !Temp.bDeleteMe)
      {
       Pick = Temp;
      }
     }
    }
   }
  }
 }

 //-------------------
 //SCENARIO E
 //-------------------
 if (CurWeapon.AccesoryName ~= String(E))
 {
  Temp = CraftingAccesory(Player.FindInventoryType(F));
  
  if (Temp != None && !Temp.bDeleteMe)
  {
   Pick = Temp;
  }
  if (Temp == None || Temp.bDeleteMe)
  {
   Temp = CraftingAccesory(Player.FindInventoryType(A));
  
   if (Temp != None && !Temp.bDeleteMe)
   {
    Pick = Temp;
   }
   if (Temp == None || Temp.bDeleteMe)
   {
    Temp = CraftingAccesory(Player.FindInventoryType(B));
   
    if (Temp != None && !Temp.bDeleteMe)
    {
     Pick = Temp;
    }
    if (Temp == None || Temp.bDeleteMe)
    {
     Temp = CraftingAccesory(Player.FindInventoryType(C));
    
     if (Temp != None && !Temp.bDeleteMe)
     {
      Pick = Temp;
     }
     if (Temp == None || Temp.bDeleteMe)
     {
      Temp = CraftingAccesory(Player.FindInventoryType(D));
     
      if (Temp != None && !Temp.bDeleteMe)
      {
       Pick = Temp;
      }
     }
    }
   }
  }
 }

 //-------------------
 //SCENARIO F
 //-------------------
 if (CurWeapon.AccesoryName ~= String(F))
 {
  Temp = CraftingAccesory(Player.FindInventoryType(A));
  
  if (Temp != None && !Temp.bDeleteMe)
  {
   Pick = Temp;
  }
  if (Temp == None || Temp.bDeleteMe)
  {
   Temp = CraftingAccesory(Player.FindInventoryType(B));
  
   if (Temp != None && !Temp.bDeleteMe)
   {
    Pick = Temp;
   }
   if (Temp == None || Temp.bDeleteMe)
   {
    Temp = CraftingAccesory(Player.FindInventoryType(C));
   
    if (Temp != None && !Temp.bDeleteMe)
    {
     Pick = Temp;
    }
    if (Temp == None || Temp.bDeleteMe)
    {
     Temp = CraftingAccesory(Player.FindInventoryType(D));
    
     if (Temp != None && !Temp.bDeleteMe)
     {
      Pick = Temp;
     }
     if (Temp == None || Temp.bDeleteMe)
     {
      Temp = CraftingAccesory(Player.FindInventoryType(E));
     
      if (Temp != None && !Temp.bDeleteMe)
      {
       Pick = Temp;
      }
     }
    }
   }
  }
 }
 
 if (Pick != None)
 {
  AbsClearIcons();
  RemoveAccesory();
  CurAccesory = Pick;
  ReplaceAccesory();
  UpdateParts();
  UpdateAccesory();
  UpdateIcons();
 }
}

function BackwardAccesory()
{
 local class<CraftingAccesory> A, B, C, D, E, F;
 local CraftingAccesory Temp, Pick;
 
 CurWeapon.GetValidAccesoryClasses(A, B, C, D, E, F);
 
 //-------------------
 //SCENARIO NULL
 //-------------------
 if (CurWeapon.AccesoryName ~= "")
 {
  Temp = CraftingAccesory(Player.FindInventoryType(F));
  
  if (Temp != None && !Temp.bDeleteMe)
  {
   Pick = Temp;
  }
  if (Temp == None || Temp.bDeleteMe)
  {
   Temp = CraftingAccesory(Player.FindInventoryType(E));
  
   if (Temp != None && !Temp.bDeleteMe)
   {
    Pick = Temp;
   }
   if (Temp == None || Temp.bDeleteMe)
   {
    Temp = CraftingAccesory(Player.FindInventoryType(D));
   
    if (Temp != None && !Temp.bDeleteMe)
    {
     Pick = Temp;
    }
    if (Temp == None || Temp.bDeleteMe)
    {
     Temp = CraftingAccesory(Player.FindInventoryType(C));
    
     if (Temp != None && !Temp.bDeleteMe)
     {
      Pick = Temp;
     }
     if (Temp == None || Temp.bDeleteMe)
     {
      Temp = CraftingAccesory(Player.FindInventoryType(B));
     
       if (Temp != None && !Temp.bDeleteMe)
      {
       Pick = Temp;
      }
      if (Temp == None || Temp.bDeleteMe)
      {
       Temp = CraftingAccesory(Player.FindInventoryType(A));
      
       if (Temp != None && !Temp.bDeleteMe)
       {
        Pick = Temp;
       }
      }
     }
    }
   }
  }
 }
 
 //-------------------
 //SCENARIO A
 //-------------------
 if (CurWeapon.AccesoryName ~= String(A))
 {
  Temp = CraftingAccesory(Player.FindInventoryType(F));
  
  if (Temp != None && !Temp.bDeleteMe)
  {
   Pick = Temp;
  }
  if (Temp == None || Temp.bDeleteMe)
  {
   Temp = CraftingAccesory(Player.FindInventoryType(E));
  
   if (Temp != None && !Temp.bDeleteMe)
   {
    Pick = Temp;
   }
   if (Temp == None || Temp.bDeleteMe)
   {
    Temp = CraftingAccesory(Player.FindInventoryType(D));
   
    if (Temp != None && !Temp.bDeleteMe)
    {
     Pick = Temp;
    }
    if (Temp == None || Temp.bDeleteMe)
    {
     Temp = CraftingAccesory(Player.FindInventoryType(C));
    
     if (Temp != None && !Temp.bDeleteMe)
     {
      Pick = Temp;
     }
     if (Temp == None || Temp.bDeleteMe)
     {
      Temp = CraftingAccesory(Player.FindInventoryType(B));
     
      if (Temp != None && !Temp.bDeleteMe)
      {
       Pick = Temp;
      }
     }
    }
   }
  }
 }

 //-------------------
 //SCENARIO B
 //-------------------
 if (CurWeapon.AccesoryName ~= String(B))
 {
  Temp = CraftingAccesory(Player.FindInventoryType(A));
  
  if (Temp != None && !Temp.bDeleteMe)
  {
   Pick = Temp;
  }
  if (Temp == None || Temp.bDeleteMe)
  {
   Temp = CraftingAccesory(Player.FindInventoryType(F));
  
   if (Temp != None && !Temp.bDeleteMe)
   {
    Pick = Temp;
   }
   if (Temp == None || Temp.bDeleteMe)
   {
    Temp = CraftingAccesory(Player.FindInventoryType(E));
   
    if (Temp != None && !Temp.bDeleteMe)
    {
     Pick = Temp;
    }
    if (Temp == None || Temp.bDeleteMe)
    {
     Temp = CraftingAccesory(Player.FindInventoryType(D));
    
     if (Temp != None && !Temp.bDeleteMe)
     {
      Pick = Temp;
     }
     if (Temp == None || Temp.bDeleteMe)
     {
      Temp = CraftingAccesory(Player.FindInventoryType(C));
     
      if (Temp != None && !Temp.bDeleteMe)
      {
       Pick = Temp;
      }
     }
    }
   }
  }
 }

 //-------------------
 //SCENARIO C
 //-------------------
 if (CurWeapon.AccesoryName ~= String(C))
 {
  Temp = CraftingAccesory(Player.FindInventoryType(B));
  
  if (Temp != None && !Temp.bDeleteMe)
  {
   Pick = Temp;
  }
  if (Temp == None || Temp.bDeleteMe)
  {
   Temp = CraftingAccesory(Player.FindInventoryType(A));
  
   if (Temp != None && !Temp.bDeleteMe)
   {
    Pick = Temp;
   }
   if (Temp == None || Temp.bDeleteMe)
   {
    Temp = CraftingAccesory(Player.FindInventoryType(F));
   
    if (Temp != None && !Temp.bDeleteMe)
    {
     Pick = Temp;
    }
    if (Temp == None || Temp.bDeleteMe)
    {
     Temp = CraftingAccesory(Player.FindInventoryType(E));
    
     if (Temp != None && !Temp.bDeleteMe)
     {
      Pick = Temp;
     }
     if (Temp == None || Temp.bDeleteMe)
     {
      Temp = CraftingAccesory(Player.FindInventoryType(D));
     
      if (Temp != None && !Temp.bDeleteMe)
      {
       Pick = Temp;
      }
     }
    }
   }
  }
 }

 //-------------------
 //SCENARIO D
 //-------------------
 if (CurWeapon.AccesoryName ~= String(D))
 {
  Temp = CraftingAccesory(Player.FindInventoryType(C));
  
  if (Temp != None && !Temp.bDeleteMe)
  {
   Pick = Temp;
  }
  if (Temp == None || Temp.bDeleteMe)
  {
   Temp = CraftingAccesory(Player.FindInventoryType(B));
  
   if (Temp != None && !Temp.bDeleteMe)
   {
    Pick = Temp;
   }
   if (Temp == None || Temp.bDeleteMe)
   {
    Temp = CraftingAccesory(Player.FindInventoryType(A));
   
    if (Temp != None && !Temp.bDeleteMe)
    {
     Pick = Temp;
    }
    if (Temp == None || Temp.bDeleteMe)
    {
     Temp = CraftingAccesory(Player.FindInventoryType(F));
    
     if (Temp != None && !Temp.bDeleteMe)
     {
      Pick = Temp;
     }
     if (Temp == None || Temp.bDeleteMe)
     {
      Temp = CraftingAccesory(Player.FindInventoryType(E));
     
      if (Temp != None && !Temp.bDeleteMe)
      {
       Pick = Temp;
      }
     }
    }
   }
  }
 }

 //-------------------
 //SCENARIO E
 //-------------------
 if (CurWeapon.AccesoryName ~= String(E))
 {
  Temp = CraftingAccesory(Player.FindInventoryType(D));
  
  if (Temp != None && !Temp.bDeleteMe)
  {
   Pick = Temp;
  }
  if (Temp == None || Temp.bDeleteMe)
  {
   Temp = CraftingAccesory(Player.FindInventoryType(C));
  
   if (Temp != None && !Temp.bDeleteMe)
   {
    Pick = Temp;
   }
   if (Temp == None || Temp.bDeleteMe)
   {
    Temp = CraftingAccesory(Player.FindInventoryType(B));
   
    if (Temp != None && !Temp.bDeleteMe)
    {
     Pick = Temp;
    }
    if (Temp == None || Temp.bDeleteMe)
    {
     Temp = CraftingAccesory(Player.FindInventoryType(A));
    
     if (Temp != None && !Temp.bDeleteMe)
     {
      Pick = Temp;
     }
     if (Temp == None || Temp.bDeleteMe)
     {
      Temp = CraftingAccesory(Player.FindInventoryType(F));
     
      if (Temp != None && !Temp.bDeleteMe)
      {
       Pick = Temp;
      }
     }
    }
   }
  }
 }

 //-------------------
 //SCENARIO F
 //-------------------
 if (CurWeapon.AccesoryName ~= String(F))
 {
  Temp = CraftingAccesory(Player.FindInventoryType(E));
  
  if (Temp != None && !Temp.bDeleteMe)
  {
   Pick = Temp;
  }
  if (Temp == None || Temp.bDeleteMe)
  {
   Temp = CraftingAccesory(Player.FindInventoryType(D));
  
   if (Temp != None && !Temp.bDeleteMe)
   {
    Pick = Temp;
   }
   if (Temp == None || Temp.bDeleteMe)
   {
    Temp = CraftingAccesory(Player.FindInventoryType(C));
   
    if (Temp != None && !Temp.bDeleteMe)
    {
     Pick = Temp;
    }
    if (Temp == None || Temp.bDeleteMe)
    {
     Temp = CraftingAccesory(Player.FindInventoryType(B));
    
     if (Temp != None && !Temp.bDeleteMe)
     {
      Pick = Temp;
     }
     if (Temp == None || Temp.bDeleteMe)
     {
      Temp = CraftingAccesory(Player.FindInventoryType(A));
     
      if (Temp != None && !Temp.bDeleteMe)
      {
       Pick = Temp;
      }
     }
    }
   }
  }
 }
 
 if (Pick != None)
 {
  AbsClearIcons();
  RemoveAccesory();
  CurAccesory = Pick;
  ReplaceAccesory();
  UpdateParts();
  UpdateAccesory();
  UpdateIcons();
 }
}

//==================================================
//--------------------------------------------------
//PREV PART FUNCTIONS END
//--------------------------------------------------
//==================================================

defaultproperties
{
     ColorPickerValues(0)="|cffffff"
     ColorPickerValues(1)="|ce5e500"
     ColorPickerValues(2)="|c20a748"
     ColorPickerValues(3)="|c0099db"
     ColorPickerValues(4)="|c9a459b"
     ColorPickerValues(5)="|cdf1b22"
     ColorPickerValues(6)="|cff7825"

     Title="Custom Rifle Equipping"
     exitButtonText="Done"
     ClientWidth=512
     ClientHeight=384

     clientTextures(0)=Texture'WorkBenchRifleBG1'
     clientTextures(1)=Texture'WorkBenchRifleBG2'
     clientTextures(2)=Texture'WorkBenchRifleBG3'
     clientTextures(3)=Texture'WorkBenchRifleBG4'

     bActionButtonBarActive=True
     bUsesHelpWindow=False
     ScreenType=ST_Persona
     TextureRows=2
     TextureCols=2

}
